/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.orient.P2Facet;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientP2Facet
extends FacetSupport
implements P2Facet {
    public static final Collection<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1);

    @Override
    public Component findOrCreateComponent(StorageTx tx, P2Attributes attributes) {
        String name = attributes.getComponentName();
        String version = attributes.getComponentVersion();
        Component component = this.findComponent(tx, this.getRepository(), name, version);
        if (component == null) {
            Bucket bucket = tx.findBucket(this.getRepository());
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(version);
            if (attributes.getPluginName() != null) {
                component.formatAttributes().set("pluginName", (Object)attributes.getPluginName());
            }
            tx.saveComponent(component);
        }
        return component;
    }

    @Override
    @TransactionalStoreBlob
    public Content doCreateOrSaveComponent(P2Attributes p2Attributes, TempBlob componentContent, Payload payload, AssetKind assetKind) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = this.findOrCreateComponent(tx, p2Attributes);
        Asset asset = this.findAsset(tx, bucket, p2Attributes.getPath());
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(p2Attributes.getPath());
            asset.formatAttributes().set("pluginName", (Object)p2Attributes.getPluginName());
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.saveAsset(tx, asset, componentContent, payload);
    }

    @Override
    public Asset findOrCreateAsset(StorageTx tx, Component component, String path, P2Attributes attributes) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            asset.formatAttributes().set("pluginName", (Object)attributes.getPluginName());
            asset.formatAttributes().set("asset_kind", (Object)attributes.getAssetKind());
            tx.saveAsset(asset);
        }
        return asset;
    }

    @Override
    public Asset findOrCreateAsset(StorageTx tx, String path) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)this.getAssetKind(path).name());
            tx.saveAsset(asset);
        }
        return asset;
    }

    @Nullable
    public Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Override
    @Nullable
    public Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, TempBlob contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, (InputStreamSupplier)contentSupplier, contentType, contentAttributes);
    }

    public Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, HASH_ALGORITHMS, null, contentType, false);
        asset.markAsDownloaded();
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    @Override
    public Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    public AssetKind getAssetKind(String path) {
        return P2PathUtils.getAssetKind(path);
    }
}

