/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.util;

import com.sonatype.nexus.repository.p2.internal.exception.AttributeParsingException;
import com.sonatype.nexus.repository.p2.internal.util.JarExtractor;
import com.sonatype.nexus.repository.p2.internal.util.TempBlobConverter;
import java.io.IOException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public class PropertyParser {
    private static final String PROPERTY_RESOURCE_BUNDLE_EXTENSION = ".properties";
    private JarExtractor<PropertyResourceBundle> jarExtractor;

    @Inject
    public PropertyParser(TempBlobConverter tempBlobConverter) {
        this.jarExtractor = new JarExtractor<PropertyResourceBundle>(tempBlobConverter){

            @Override
            protected PropertyResourceBundle createSpecificEntity(JarInputStream jis, JarEntry jarEntry) throws IOException {
                return new PropertyResourceBundle(jis);
            }
        };
    }

    protected Optional<PropertyResourceBundle> getBundleProperties(InputStreamSupplier inputSupplier, String extension, @Nullable String startNameForSearch) throws IOException, AttributeParsingException {
        return this.jarExtractor.getSpecificEntity(inputSupplier, extension, String.valueOf(startNameForSearch) + PROPERTY_RESOURCE_BUNDLE_EXTENSION);
    }

    protected String extractValueFromProperty(String value, Optional<PropertyResourceBundle> propertyResourceBundleOpt) {
        if (!propertyResourceBundleOpt.isPresent() || value == null || !propertyResourceBundleOpt.get().containsKey(value.substring(1))) {
            return value;
        }
        return propertyResourceBundleOpt.get().getString(value.substring(1));
    }
}

