/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.util;

import com.sonatype.nexus.repository.p2.internal.exception.AttributeParsingException;
import com.sonatype.nexus.repository.p2.internal.util.TempBlobConverter;
import java.io.IOException;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.io.InputStreamSupplier;

public abstract class JarExtractor<T> {
    private TempBlobConverter tempBlobConverter;

    public JarExtractor(TempBlobConverter tempBlobConverter) {
        this.tempBlobConverter = tempBlobConverter;
    }

    protected Optional<T> getSpecificEntity(InputStreamSupplier inputSupplier, String extension, @Nullable String startNameForSearch) throws IOException, AttributeParsingException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarInputStream jis = this.getJarStreamFromBlob(inputSupplier, extension);){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                if (startNameForSearch == null || !jarEntry.getName().startsWith(startNameForSearch)) continue;
                return Optional.ofNullable(this.createSpecificEntity(jis, jarEntry));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Optional.empty();
    }

    protected abstract T createSpecificEntity(JarInputStream var1, JarEntry var2) throws IOException, AttributeParsingException;

    private JarInputStream getJarStreamFromBlob(InputStreamSupplier inputSupplier, String extension) throws IOException {
        if ("jar".equals(extension)) {
            return new JarInputStream(inputSupplier.get());
        }
        return new JarInputStream(this.tempBlobConverter.getJarFromPackGz(inputSupplier));
    }
}

