/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.metadata;

import com.sonatype.nexus.repository.p2.internal.proxy.StreamCopier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.SafeXml;

public abstract class XmlTransformer
extends ComponentSupport
implements StreamCopier.StreamTransformer {
    @Override
    public void transform(InputStream in, OutputStream out) throws IOException {
        XMLInputFactory inputFactory = SafeXml.newXmlInputFactory();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        try {
            try {
                reader = inputFactory.createXMLEventReader(in);
                writer = outputFactory.createXMLEventWriter(out);
                this.transform(reader, writer);
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            if (reader != null) {
                this.close(reader);
            }
            if (writer != null) {
                this.close(writer);
            }
            IOUtils.close((Closeable)in);
            IOUtils.close((Closeable)out);
        }
    }

    private void close(XMLEventReader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {}
    }

    private void close(XMLEventWriter writer) {
        try {
            writer.close();
        }
        catch (Exception exception) {}
    }

    protected abstract void transform(XMLEventReader var1, XMLEventWriter var2) throws XMLStreamException;

    static boolean isStartTagWithName(@Nullable XMLEvent tag, String name) {
        StartElement startElement;
        return tag != null && tag.getEventType() == 1 && (startElement = tag.asStartElement()).getName().getLocalPart().equals(name);
    }

    static boolean isEndTagWithName(@Nullable XMLEvent tag, String name) {
        EndElement endElement;
        return tag != null && tag.getEventType() == 2 && (endElement = tag.asEndElement()).getName().getLocalPart().equals(name);
    }
}

