/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.metadata;

import com.sonatype.nexus.repository.p2.internal.metadata.XmlTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class RemoveMirrorTransformer
extends XmlTransformer {
    private static final String MIRRORS_URL_PROPERTY = "p2.mirrorsURL";
    private static final String PROPERTIES_KEY = "properties";
    private String mirrorsUrl;

    public Optional<String> getMirrorsUrl() {
        return Optional.ofNullable(this.mirrorsUrl);
    }

    @Override
    protected void transform(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        XMLEvent previous = null;
        ArrayList<XMLEvent> buffer = new ArrayList<XMLEvent>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!(buffer.isEmpty() && !RemoveMirrorTransformer.isStartTagWithName(event, PROPERTIES_KEY) || this.isMirrorsUrlProperty(event) || this.isMirrorsUrlProperty(previous))) {
                buffer.add(event);
            }
            if (buffer.isEmpty()) {
                writer.add(event);
            }
            if (RemoveMirrorTransformer.isEndTagWithName(event, PROPERTIES_KEY)) {
                for (XMLEvent xmlEvent : buffer) {
                    if (RemoveMirrorTransformer.isStartTagWithName(xmlEvent, PROPERTIES_KEY)) {
                        xmlEvent = RemoveMirrorTransformer.updateSize(xmlEvent.asStartElement(), this.countPropertyTags(buffer), eventFactory);
                    }
                    writer.add(xmlEvent);
                }
                buffer.clear();
            }
            previous = event;
        }
    }

    private boolean isMirrorsUrlProperty(@Nullable XMLEvent event) {
        Attribute name;
        if (RemoveMirrorTransformer.isStartTagWithName(event, "property") && (name = event.asStartElement().getAttributeByName(new QName("name"))) != null && name.getValue().equals(MIRRORS_URL_PROPERTY)) {
            Attribute value = event.asStartElement().getAttributeByName(new QName("value"));
            if (value != null) {
                this.mirrorsUrl = value.getValue();
            }
            return true;
        }
        return false;
    }

    private int countPropertyTags(List<XMLEvent> buffer) {
        int count = 0;
        for (XMLEvent xmlEvent : buffer) {
            if (!RemoveMirrorTransformer.isStartTagWithName(xmlEvent, "property")) continue;
            ++count;
        }
        return count;
    }

    private static XMLEvent updateSize(StartElement tag, int size, XMLEventFactory eventFactory) {
        Iterator<Attribute> updatedAttributes = RemoveMirrorTransformer.updateSizeAttribute(tag.getAttributes(), size, eventFactory);
        return eventFactory.createStartElement(tag.getName().getPrefix(), tag.getName().getNamespaceURI(), tag.getName().getLocalPart(), updatedAttributes, null);
    }

    private static Iterator<Attribute> updateSizeAttribute(Iterator<Attribute> attributes, int size, XMLEventFactory eventFactory) {
        ArrayList<Attribute> processedAttributes = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (attribute.getName().getLocalPart().equals("size")) {
                Attribute sizeAttribute = eventFactory.createAttribute(attribute.getName(), Integer.toString(size));
                if (sizeAttribute == null) continue;
                processedAttributes.add(sizeAttribute);
                continue;
            }
            processedAttributes.add(attribute);
        }
        return processedAttributes.iterator();
    }
}

