/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.metadata;

import com.sonatype.nexus.repository.p2.internal.metadata.UriToSiteHashUtil;
import com.sonatype.nexus.repository.p2.internal.metadata.XmlTransformer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompositeRepositoryRewriter
extends XmlTransformer {
    private final URI baseUri;
    private final boolean isRoot;
    private List<String> urls = new ArrayList<String>();
    private final Function<String, String> uriConverter;

    public CompositeRepositoryRewriter(URI baseUri, boolean isRoot, UnaryOperator<String> uriConverter) {
        this.baseUri = baseUri;
        this.isRoot = isRoot;
        this.uriConverter = uriConverter;
    }

    public CompositeRepositoryRewriter(URI baseUri, boolean isRoot) {
        this(baseUri, isRoot, UnaryOperator.identity());
    }

    public List<String> getUrls() {
        return this.urls;
    }

    @Override
    protected void transform(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        ArrayList<XMLEvent> buffer = new ArrayList<XMLEvent>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (CompositeRepositoryRewriter.isStartTagWithName(event, "child")) {
                buffer.add(this.changeLocationAttribute((StartElement)event));
            } else {
                buffer.add(event);
            }
            for (XMLEvent xmlEvent : buffer) {
                writer.add(xmlEvent);
            }
            buffer.clear();
        }
    }

    private XMLEvent changeLocationAttribute(StartElement locationElement) {
        QName locationAttrName = new QName("location");
        Attribute locationAttribute = locationElement.getAttributeByName(locationAttrName);
        if (locationAttribute == null) {
            return locationElement;
        }
        String location = this.uriConverter.apply(locationAttribute.getValue());
        String remoteUrl = this.baseUri.resolve(location).toString();
        if (!remoteUrl.endsWith("/")) {
            remoteUrl = String.valueOf(remoteUrl) + '/';
        }
        this.urls.add(remoteUrl);
        String path = this.derivePath(remoteUrl);
        return XMLEventFactory.newInstance().createStartElement(new QName("child"), Collections.singletonList(XMLEventFactory.newInstance().createAttribute(locationAttrName, path)).iterator(), Collections.emptyIterator());
    }

    private String derivePath(String remoteUrl) {
        StringBuilder path = new StringBuilder();
        if (!this.isRoot) {
            path.append("../");
        }
        path.append(UriToSiteHashUtil.map(remoteUrl));
        return path.append('/').toString();
    }
}

