/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.datastore.internal.proxy;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.p2.datastore.P2ContentFacet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Facet.Exposed
public class P2ProxyCacheInvalidatorFacet
extends FacetSupport {
    @Subscribe
    @AllowConcurrentEvents
    protected void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        if (!repository.getName().equals(this.getRepository().getName())) {
            return;
        }
        if (!Objects.equals(P2ProxyCacheInvalidatorFacet.getRemoteUrl(repository.getConfiguration()), P2ProxyCacheInvalidatorFacet.getRemoteUrl(event.getOldConfiguration()))) {
            this.log.info("URL changed for p2 repository: {}", (Object)this.getRepository().getName());
            this.deleteAssets();
        }
    }

    public void deleteAssets() {
        Repository repository = this.getRepository();
        this.log.info("Removing cached assets in p2 proxy repository: {}", (Object)repository);
        Continuations.iterableOf((arg_0, arg_1) -> ((FluentComponents)((P2ContentFacet)repository.facet(P2ContentFacet.class)).components()).browse(arg_0, arg_1)).forEach(c -> {
            CancelableHelper.checkCancellation();
            this.log.debug("Deleting component: {}", (Object)c.name());
            c.assets().forEach(FluentAsset::delete);
            c.delete();
        });
    }

    private static Object getRemoteUrl(Configuration configuration) {
        return Optional.ofNullable((Map)configuration.getAttributes().get("proxy")).map(proxy -> proxy.get("remoteUrl")).orElse(null);
    }
}

