/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.command;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Parsing;
import org.apache.karaf.shell.api.console.Candidate;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.action.command.ArgumentCompleter;
import org.apache.karaf.shell.impl.action.command.DefaultActionPreparator;
import org.apache.karaf.shell.impl.action.command.ManagerImpl;

public class ActionCommand
implements org.apache.karaf.shell.api.console.Command {
    private final ManagerImpl manager;
    private final Class<? extends Action> actionClass;

    public ActionCommand(ManagerImpl manager, Class<? extends Action> actionClass) {
        this.manager = manager;
        this.actionClass = actionClass;
    }

    public Class<? extends Action> getActionClass() {
        return this.actionClass;
    }

    public String getScope() {
        return this.actionClass.getAnnotation(Command.class).scope();
    }

    public String getName() {
        return this.actionClass.getAnnotation(Command.class).name();
    }

    public String getDescription() {
        return this.actionClass.getAnnotation(Command.class).description();
    }

    public Completer getCompleter(boolean scoped) {
        return new ArgumentCompleter(this, scoped);
    }

    public Parser getParser() {
        Parsing parsing = this.actionClass.getAnnotation(Parsing.class);
        if (parsing != null) {
            return new DelayedParser(parsing.value());
        }
        return null;
    }

    protected Completer getCompleter(Class<?> clazz) {
        return new DelayedCompleter(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session, List<Object> arguments) throws Exception {
        Action action = this.createNewAction(session);
        try {
            if (new DefaultActionPreparator().prepare(action, session, arguments)) {
                Object object = action.execute();
                return object;
            }
        }
        finally {
            this.releaseAction(action);
        }
        return null;
    }

    protected Action createNewAction(Session session) {
        try {
            return this.manager.instantiate(this.actionClass, session.getRegistry());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to creation command action " + this.actionClass.getName(), e);
        }
    }

    protected void releaseAction(Action action) throws Exception {
        this.manager.release(action);
    }

    public static class DelayedParser
    implements Parser {
        private final Class<?> clazz;

        public DelayedParser(Class<?> clazz) {
            this.clazz = clazz;
        }

        public CommandLine parse(Session session, String command, int cursor) {
            Object service = session.getRegistry().getService(this.clazz);
            if (service instanceof Parser) {
                return ((Parser)service).parse(session, command, cursor);
            }
            throw new IllegalStateException("Could not find specified parser");
        }

        public String preprocess(Session session, CommandLine commandLine) {
            Object service = session.getRegistry().getService(this.clazz);
            if (service instanceof Parser) {
                return ((Parser)service).preprocess(session, commandLine);
            }
            throw new IllegalStateException("Could not find specified parser");
        }
    }

    public static class DelayedCompleter
    implements Completer {
        private final Class<?> clazz;

        public DelayedCompleter(Class<?> clazz) {
            this.clazz = clazz;
        }

        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
            Object service = session.getRegistry().getService(this.clazz);
            if (service instanceof Completer) {
                return ((Completer)service).complete(session, commandLine, candidates);
            }
            return -1;
        }

        public void completeCandidates(Session session, CommandLine commandLine, List<Candidate> candidates) {
            Object service = session.getRegistry().getService(this.clazz);
            if (service instanceof Completer) {
                ((Completer)service).completeCandidates(session, commandLine, candidates);
            }
        }
    }
}

