/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.defaultrole.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.defaultrole.DefaultRoleRealm;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.realm.RealmManager;
import org.sonatype.nexus.security.role.Role;

@Named(value="DefaultRoleRealm")
@Singleton
public class DefaultRoleHealthCheck
extends HealthCheck {
    private final RealmManager realmManager;
    private final DefaultRoleRealm defaultRoleRealm;
    private final SecuritySystem securitySystem;

    @Inject
    public DefaultRoleHealthCheck(RealmManager realmManager, DefaultRoleRealm defaultRoleRealm, SecuritySystem securitySystem) {
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.defaultRoleRealm = (DefaultRoleRealm)((Object)Preconditions.checkNotNull((Object)((Object)defaultRoleRealm)));
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    protected HealthCheck.Result check() throws Exception {
        if (!this.realmManager.isRealmEnabled("DefaultRole")) {
            return HealthCheck.Result.healthy((String)"Default Role Realm not in use.");
        }
        if (this.defaultRoleRealm.getRole() == null) {
            return HealthCheck.Result.unhealthy((String)"Default Role Realm is enabled but not configured.");
        }
        Role matched = this.securitySystem.listRoles("default").stream().filter(role -> role.getRoleId().equals(this.defaultRoleRealm.getRole())).findFirst().orElse(null);
        if (matched == null) {
            return HealthCheck.Result.unhealthy((String)"Default Role Realm configured to use role %s which doesn't exist.", (Object[])new Object[]{this.defaultRoleRealm.getRole()});
        }
        return HealthCheck.Result.healthy((String)"Default Role Realm configured to use role %s.", (Object[])new Object[]{this.defaultRoleRealm.getRole()});
    }
}

